// gcc -o sample.exe sample.c WAV.c
#include <stdio.h>
#include "WAV.h"
#define MAX_SAMPLE_SIZE 16
#define WAV_HEADER_SIZE 44
#define OUTPUT_RATE (8000ULL)

int main(int argc, char* argv[]){
	FILE *fp;
	WAVHeader w;
	char hdr[44];
	unsigned long i,n;
	unsigned long bytesPerSample=0;
	unsigned long sampleCount=0;
	char sample[MAX_SAMPLE_SIZE];
	unsigned long sz=0;
	unsigned long pos=0;
	long offset=0;					//for tracking sample conversion
	unsigned char samples[MAX_SAMPLE_SIZE];
	unsigned char outBytes[4]={0,0,0,0};
	int j;
	if(argc<2){
		printf("WAVE SAMPLE CONVERTER for MMBASIC\n");
		printf("Supply the name of a single chunk .WAV file\n");
		printf("eg: sample in.wav\n");
		printf("Output to console\n");
		printf("(C) 2020 Silicon Chip Publications\n");
		return 0;
	}
	fp=fopen(argv[1], "rb");
	if(!fp){		//file error
		printf("Input file error on '");		
		printf(argv[1]);
		printf("'\n");		
		fclose(fp);
		return -1;		
	}
	
	WAVinitHeader(&w);	
	n=fread(hdr,1,WAV_HEADER_SIZE,fp);	
	if(n<WAV_HEADER_SIZE){
		printf("Header smaller than expected; (%u/%u) bytes.\n",n,WAV_HEADER_SIZE);		
		fclose(fp);
		return -1;		
	}
	WAVreadWAVHeader(hdr,&w,WAV_HEADER_SIZE);
	bytesPerSample=(w.fmtHeader.bitsPerSample*w.fmtHeader.numChannels) / 8;	
	if(bytesPerSample<1){
		printf("Data invalid (channel or bits per sample is zero).\n");		
		fclose(fp);
		return -1;		
	}
	sampleCount=w.dataHeader.data.chunkSize/bytesPerSample;
	printf("'Samplerate:      %u\n",w.fmtHeader.sampleRate);		
	printf("'Format:          %u\n",w.fmtHeader.audioFormat);		
	printf("'Channels:        %u\n",w.fmtHeader.numChannels);		
	printf("'Bytes per sample:%u\n",bytesPerSample);		
	printf("'Data Chunk Size: %u\n",w.dataHeader.data.chunkSize);		
	printf("'Data samples:    %u\n",sampleCount);			
	if(w.fmtHeader.audioFormat != 0x01){
		printf("Audio format not supported: PCM (0x01) only\n");		
		fclose(fp);
		return -1;		
	}
	if(bytesPerSample>MAX_SAMPLE_SIZE){
		printf("Sample size larger than %u bytes per sample is unsupported.\n",MAX_SAMPLE_SIZE);		
		fclose(fp);
		return -1;		
	}
	//process data here
	sz=OUTPUT_RATE*sampleCount/w.fmtHeader.sampleRate;
	printf("CFUNCTION %s AS INTEGER\n 00000000\n %0.8lX '%u data bytes\n ",argv[1],sz,sz);			//header
	while(pos<sz){
		while(offset<w.fmtHeader.sampleRate){
			n=fread(samples,1,bytesPerSample,fp);
			offset=offset+OUTPUT_RATE;
			if(n!=bytesPerSample){
				printf("\r\nFile error n!=BPS, pos=%u/size=%u/sampleCount=%u/fpos=%i\r\n",pos,sz,sampleCount,ftell(fp));		
				fclose(fp);
				return -1;
			}
		}
		while(offset>=w.fmtHeader.sampleRate){
			offset=offset-w.fmtHeader.sampleRate;
			if(bytesPerSample==1){							//handle channel/byte count variations
				outBytes[pos&3]=samples[0];
			}else if(bytesPerSample==2){					//handle channel/byte count variations
				if(w.fmtHeader.numChannels==1){
					//this appears to be glitching midway through test file...?
					outBytes[pos&3]=samples[1]^0x80;		//=> 16bit mono, just use MSB, convert to unsigned
				}else{
					outBytes[pos&3]=((int)samples[0]+(int)samples[1])/2;	//=> 8bit stereo, mix
				}				
			}else if(bytesPerSample==4){					//handle channel/byte count variations
				if(w.fmtHeader.numChannels==2){				//only handle 16-bit stereo
					outBytes[pos&3]=(((int)samples[1]+(int)samples[3])/2)^0x80;		//=> 16bit stereo, just use MSBs, convert to unsigned
				}else{
					outBytes[pos&3]=0xEE;					//error marker for unhandled BPS
				}				
			}else{
				outBytes[pos&3]=0xEE;					//error marker for unhandled BPS
			}
			pos++;
			if((pos&3)==0){			//end of word
				for(j=3;j>=0;j--){		//and reverse to get LSB at right and always output 32 bits
					printf("%0.2lX",outBytes[j]);
					//outBytes[j]=0;				//clear
				}				
				if(((pos)&0x1f)==0){	//end of line
					printf("\n ");
				}else{
					printf(" ");
				}
			}
		}			
	}
	if(pos){		//still part way through a word
		while(pos&3){
			outBytes[pos&3]=0;
			pos++;
		}
		for(j=3;j>=0;j--){		//and reverse to get LSB at right and always output 32 bits
			printf("%0.2lX",outBytes[j]);
			//outBytes[j]=0;				//clear
		}				
	}	
	printf("\nEND CFUNCTION\n");
	printf("'OK %u bytes written.\n",pos);	
	fclose(fp);
	return 0;
}